function plotBehaviors(varargin)

% Requires MATLAB R2014b or later, and the following Toolboxes:
% Signal Processing Toolbox
% Image Processing Toolbox
% Statistics and Machine Learning Toolbox
% Database Toolbox
% Model-Based Calibration Toolbox
% Bioinformatics Toolbox

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% File Handling
if nargin < 1
    % default root folder for all the behaviorManager.mat files
    pathInput = '\\101.101.1.113\data\Ippei\Publication\Behaviors\';
elseif nargin == 1
    pathInput = varargin{1};
else
    error('Too many input arguments');
end

listFilesBeh = rdir([pathInput, '\*\behaviorManager.mat']); % Get a list of BehaviorsResampled.mat files in the subfolders
numFiles = numel(listFilesBeh);
if numFiles < 1
    prt('No worm to plot.');
    return
end
for nf = 1:numFiles
    df(nf, 1) = dataFormatter(listFilesBeh(nf).name);
end

flgTrans = 1;
flgFrac = 1;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Transition Analysis

if flgTrans
    m = mutantManager(df, 'transitions');
    g = graphicManager( {m.mutants(1).phases(2, 1)} );

    % Fig. 4D
    order = 'pmb';
    ranges = {'[2:2:end]', '1:end', '3'};
    s = m.preparePlotData('ratesTransition', order, ranges, false);
    s.typePlot = 'marker';
    s.posFig = [100 100 1000 260];
    s.rotationXTick = 0;
    s.widthErrorbar = 0.2;
    s.widthLine = [];
    s.sizeMarker = 9;
    g.plotND(s, 'Transition Rates');
    g.saveStats(pathInput, 'Fig4D_stats.mat');
    
    % Sup. Fig. 4 fs2
    order = 'pmb';
    ranges = {'1:end', '1:end', '1:end'};
    s = m.preparePlotData('ratesTransition', order, ranges, false);
    s.typePlot = 'marker';
    s.posFig = [100 100 1000 800];
    s.rotationXTick = 0;
    s.widthErrorbar = 0.25;
    s.widthLine = [];
    s.sizeMarker = 9;
    s.flgZebra = true;
    g.plotND(s, 'Transition Rates');
    g.saveStats(pathInput, 'Fig4_fs2_stats.mat');
    
    cl = m.extractCell('data', 'ratesTransition', 't');
    cl = cat(3, cl{:, 2});
    for x = 1:3
        for y = 1:3
            
            v = squeeze(cl(x, y, :));
            if all(~cellfun(@isempty, v))
                st(x, y) = ntests(v);
            end
        end
    end
       
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Fractions of Behaviors

if flgFrac
    
    % Fig. 4A
    order = 'mpb';
    ranges = {'1:end', '2', '1:3'};    
    m = mutantManager(df, 'fractions');
    g = graphicManager(m);
    s = m.preparePlotData('fractions', order, ranges, false);
    s.posFig = [100 100 300 800];
    s.typePlot = 'marker';
    s.titles = [];
    s.colors = repmat({[0.8 0.5 0.5]}, 1, 3);
    s.markers = repmat({'o'}, 1, 5);
    s.widthLine = [];
    s.sizeMarker = 9;
    s.widthErrorbar = 0.25;
    g.plotND(s);
    g.saveStats(pathInput, 'Fig4A_stats.mat');
    
    % Sup. Fig. 4 fs1
    order = 'pmb';
    ranges = {'[1, 2:1:end]', '1:end', '1:end'};
    m = mutantManager(df, 'fractions');
    g = graphicManager(m);
    s = m.preparePlotData('fractions', order, ranges, false);
    s.typePlot = 'marker';
    s.posFig = [100 100 1000 800];
    s.widthLine = [];
    s.sizeMarker = 9;
    s.widthErrorbar = 0.25;
    s.rotationXTick = 0;
    s.roundYtick = [2 2 2 2];
    s.flgZebra = true;
    g.plotND(s);
    g.saveStats(pathInput, 'Fig4_fs1_stats.mat');

    % Fig. 4BC
    order = 'pmb';
    ranges = {'[2:2:end]', '1:end', '2:3'};
    m = mutantManager(df, 'fractions');
    g = graphicManager(m);
    s = m.preparePlotData('fractions', order, ranges, false);
    s.typePlot = 'marker';
    s.posFig = [100 100 1000 600];
    s.widthLine = [];
    s.sizeMarker = 9;
    s.rotationXTick = 0;
    s.widthErrorbar = 0.25;
    g.plotND(s);
    g.saveStats(pathInput, 'Fig4BC_stats.mat');
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
end
%#ok<*AGROW>
